<?php 
 /**
  * 
  */
 class Retour_Vente extends CI_Controller
 {

  function __construct()
  {
    parent::__construct();
    $this->load->library('Mylibrary');
    $this->ci = & get_instance();
    $this->ci->load->library("user_agent");
    // $this->Is_Connected();
    // $this->verification();

  }

  public function Is_Connected()
  {

   if (empty($this->session->userdata('SOCAR_ID_USER')))
   {
     redirect(base_url('Login/'));
   }
 }


 public function index()
 {

  $data['title'] = "Retour Vente";
  $this->load->view('Retour_Vente_Add_View',$data);

}

public function listing()
{

  $data['title'] = "Retour Vente";
  $this->load->view('Retour_Vente_List_View',$data);

}

public function retourv()
{
  $idVenteDetails = $this->input->post('ID_VENTE_DETAILS');
  $quantiteRetourne = $this->input->post('QUANTITE_RETOURNE');
  $ID_MOTIF_RETOUR = $this->input->post('ID_MOTIF_RETOUR');
  $COMMENTAIRE = $this->input->post('COMMENTAIRE');

  $vent = $this->Model->getOne('vente_details', array('ID_VENTE_DETAILS' => $idVenteDetails));

  if($quantiteRetourne <= $vent['QUANTITE_LIVRE'] ){

    $quantiteRestant=$vent['QUANTITE_LIVRE'] - $quantiteRetourne;
    $prixRestant=$quantiteRestant*$vent['PRIX_UNITAIRE'];

    $updateResult = $this->Model->update('vente_details', 
      array('ID_VENTE_DETAILS' => $idVenteDetails), 
      array('QUANTITE_RETOURNE' => $quantiteRetourne,'QUANTITE_LIVRE' => $quantiteRestant,'ID_MOTIF_RETOUR' => $ID_MOTIF_RETOUR,'COMMENTAIRE' => $COMMENTAIRE)
    );

    $this->Model->insert_last_id('retour_historique',['ID_VENTE'=>$vent['ID_VENTE'],'ID_VENTE_DETAIL'=>$idVenteDetails,'QUANTITE'=>$quantiteRetourne]);
           // Vérifier si la vente doit être mise à jour
    $orga = $this->Model->checkvalue('vente_details', [
      'ID_VENTE' => $vent['ID_VENTE'],
      'ID_STATUS' => 2,
      'QUANTITE_RETOURNE' => NULL
    ]);

    if(!$orga){
     $this->Model->update('vente_vente', 
      array('ID_VENTE' => $vent['ID_VENTE']), 
      array('MONTANT_PAYE' =>$prixRestant ,'DATE_RETOUR' => date('Y-m-d'))
    );
   }
   

   echo '1';
 } else {
  echo '2'; 
}
}

// public function retour_vente()
// {
//     // Retrieve the selected IDs and quantities from the form
//     $selectedIds = $this->input->post('SELECT'); // Get selected IDs
//     $quantiteRetourne = $this->input->post('QUANTITE_LIVRE');
//     $ID_MOTIF_RETOUR = $this->input->post('ID_MOTIF_RETOUR');
//     $COMMENTAIRE = $this->input->post('COMMENTAIRE');
//     $prixRestant=0;
//     // Check if any IDs were selected
//     if (!empty($selectedIds) && is_array($selectedIds)) {
//       foreach ($selectedIds as  $idVenteDetails) {
//         $quantite = isset($quantiteRetourne[$idVenteDetails]) ? $quantiteRetourne[$idVenteDetails] : 0;

//         $vent = $this->Model->getOne('vente_details', ['ID_VENTE_DETAILS' => $idVenteDetails]);

//         if ($quantite > 0 && $quantite <= $vent['QUANTITE_LIVRE']) {
//           $quantiteRestant = $vent['QUANTITE_LIVRE'] - $quantite;
//           $prixRestant += $quantiteRestant * $vent['PRIX_UNITAIRE'];

//           $this->Model->update(
//             'vente_details',
//             ['ID_VENTE_DETAILS' => $idVenteDetails],
//             [
//               'QUANTITE_RETOURNE' => $quantite,
//               'QUANTITE_LIVRE' => $quantiteRestant,
//               'ID_MOTIF_RETOUR' => $ID_MOTIF_RETOUR,
//               'COMMENTAIRE' => $COMMENTAIRE
//             ]
//           );
//           $this->Model->insert_last_id('retour_historique',['ID_VENTE'=>$vent['ID_VENTE'],'ID_VENTE_DETAIL'=>$idVenteDetails,'QUANTITE'=>$quantite]);

//         }

//       }
//         // Update the overall sale record
      


//       $orga = $this->Model->checkvalue('vente_details', [
//         'ID_VENTE' => $vent['ID_VENTE'],
//         'QUANTITE_LIVRE IS NOT NULL' => NULL,
//         'QUANTITE_RETOURNE' => NULL
//       ]);

//       if(!$orga){
//         $this->Model->update(
//           'vente_vente',
//           ['ID_VENTE' => $vent['ID_VENTE']],
//           [
//             'MONTANT_PAYE' => $prixRestant,
//             'DATE_RETOUR' => date('Y-m-d')
//           ]
//         );
//       }
//         // Set success message
//       $message = "<div class='alert alert-success' id='message'>
//       Enregistrement fait avec succès.
//       <button type='button' class='close' data-dismiss='alert'>&times;</button>
//       </div>";
//       $this->session->set_flashdata(['message' => $message]);
//     } else {
//         // Set error message if no items were selected
//       $message = "<div class='alert alert-danger' id='message'>
//       Aucun élément sélectionné ou quantité invalide.
//       <button type='button' class='close' data-dismiss='alert'>&times;</button>
//       </div>";
//       $this->session->set_flashdata(['message' => $message]);
//     }

//     // Redirect to the vente page
//     redirect(base_url('vente/Retour_Vente'));
//   }



// public function retour_vente()
// {
//     // Récupération des données du formulaire
//     $selectedIds = $this->input->post('SELECT');
//     $quantiteRetourne = $this->input->post('QUANTITE_LIVRE');
//     $ID_MOTIF_RETOUR = $this->input->post('ID_MOTIF_RETOUR');
//     $COMMENTAIRE = $this->input->post('COMMENTAIRE');
//     $ID_VENTE = $this->input->post('ID_VENTE'); // Ajout important
    
//     $prixRestant = 0;
//     $hasError = false;
//     $processedItems = [];

//     // Validation des entrées
//     if (empty($selectedIds) || !is_array($selectedIds)) {
//         $this->session->set_flashdata('message', $this->getErrorAlert('Aucun élément sélectionné'));
//         redirect(base_url('vente/Retour_Vente'));
//         return;
//     }

//     if (empty($ID_MOTIF_RETOUR)) {
//         $this->session->set_flashdata('message', $this->getErrorAlert('Veuillez sélectionner un motif de retour'));
//         redirect(base_url('vente/Retour_Vente'));
//         return;
//     }

//     // Traitement des articles sélectionnés
//     foreach ($selectedIds as $idVenteDetails) {
//         $quantite = isset($quantiteRetourne[$idVenteDetails]) ? (int)$quantiteRetourne[$idVenteDetails] : 0;
        
//         if ($quantite <= 0) {
//             $hasError = true;
//             continue;
//         }

//         $vent = $this->Model->getOne('vente_details', ['ID_VENTE_DETAILS' => $idVenteDetails]);
        
//         if (!$vent) {
//             $hasError = true;
//             continue;
//         }

//         if ($quantite > $vent['QUANTITE_LIVRE']) {
//             $hasError = true;
//             continue;
//         }

//         $quantiteRestant = $vent['QUANTITE_LIVRE'] - $quantite;
//         $prixRestant += $quantiteRestant * $vent['PRIX_UNITAIRE'];

//         // Mise à jour des quantités
//         $updateData = [
//             'QUANTITE_RETOURNE' => $quantite,
//             'QUANTITE_LIVRE' => $quantiteRestant,
//             'ID_MOTIF_RETOUR' => $ID_MOTIF_RETOUR,
//             'COMMENTAIRE' => $COMMENTAIRE
//         ];

//         $this->Model->update('vente_details', ['ID_VENTE_DETAILS' => $idVenteDetails], $updateData);
        
//         // Historique
//         $this->Model->insert('retour_historique', [
//             'ID_VENTE' => $vent['ID_VENTE'],
//             'ID_VENTE_DETAIL' => $idVenteDetails,
//             'QUANTITE' => $quantite,
//             'DATE_RETOUR' => date('Y-m-d H:i:s')
//         ]);

//         $processedItems[] = $idVenteDetails;
//     }

//     // Mise à jour de la vente principale
//     if (!empty($processedItems)) {
//         // Calculer le nouveau montant total
//         $totalVente = $this->Model->getOne(
//             "SELECT SUM(QUANTITE_LIVRE * PRIX_UNITAIRE) AS total 
//              FROM vente_details 
//              WHERE ID_VENTE = {$vent['ID_VENTE']}",
//             [],
//             true
//         )['total'];

//         $this->Model->update(
//             'vente_vente',
//             ['ID_VENTE' => $vent['ID_VENTE']],
//             [
//                 'MONTANT_PAYE' => $totalVente,
//                 'DATE_RETOUR' => date('Y-m-d')
//             ]
//         );

//         $message = $this->getSuccessAlert('Retour enregistré avec succès');
//     } else {
//         $message = $this->getErrorAlert('Aucun traitement effectué. Vérifiez les quantités saisies');
//     }

//     $this->session->set_flashdata('message', $message);
//     redirect(base_url('vente/Retour_Vente'));
// }

public function retour_vente()
{
    $selectedIds = $this->input->post('SELECT');
    $quantiteRetourne = $this->input->post('QUANTITE_LIVRE');
    $ID_MOTIF_RETOUR = $this->input->post('ID_MOTIF_RETOUR');
    $COMMENTAIRE = $this->input->post('COMMENTAIRE');
    $ID_VENTE = $this->input->post('ID_VENTE');
    
    $processedItems = [];
    $venteId = null;

    // Validation
    if (empty($selectedIds) || !is_array($selectedIds)) {
        $this->session->set_flashdata('message', $this->getErrorAlert('Aucun élément sélectionné'));
        redirect(base_url('vente/Retour_Vente'));
        return;
    }

    // Traitement des articles
    foreach ($selectedIds as $idVenteDetails) {
        $quantite = (int)($quantiteRetourne[$idVenteDetails] ?? 0);
        if ($quantite <= 0) continue;

        $vent = $this->Model->getOne('vente_details', ['ID_VENTE_DETAILS' => $idVenteDetails]);
        if (!$vent) continue;

        $venteId = $vent['ID_VENTE']; // Garder l'ID de vente pour la mise à jour finale
        
        // Validation quantité
        if ($quantite > $vent['QUANTITE_LIVRE']) {
            $this->session->set_flashdata('message', $this->getErrorAlert("Quantité invalide pour l'article ID $idVenteDetails"));
            redirect(base_url('vente/Retour_Vente'));
            return;
        }

        // Mise à jour des quantités
        $this->Model->update(
            'vente_details',
            ['ID_VENTE_DETAILS' => $idVenteDetails],
            [
                'QUANTITE_RETOURNE' => ($vent['QUANTITE_RETOURNE'] ?? 0) + $quantite,
                'QUANTITE_LIVRE' => $vent['QUANTITE_LIVRE'] - $quantite
            ]
        );

        // Historique
        $this->Model->insert('retour_historique', [
            'ID_VENTE' => $venteId,
            'ID_VENTE_DETAIL' => $idVenteDetails,
            'QUANTITE' => $quantite,
            'ID_MOTIF_RETOUR' => $ID_MOTIF_RETOUR,
            'COMMENTAIRE' => $COMMENTAIRE,
            'DATE_RETOUR' => date('Y-m-d H:i:s')
        ]);

        $processedItems[] = $idVenteDetails;
    }

    // Mise à jour globale de la vente si des articles ont été traités
    if (!empty($processedItems) && $venteId) {
        // Vérifier s'il reste des articles non retournés
        $hasUnreturnedItems = $this->Model->checkvalue('vente_details', [
            'ID_VENTE' => $venteId,
            'QUANTITE_LIVRE >' => 0,
            'QUANTITE_RETOURNE IS NULL' => null
        ]);

        // Si tous les articles ont été traités
        if (!$hasUnreturnedItems) {
            // Calcul du nouveau montant total
            $totalResult = $this->Model->getOne(
                "SELECT SUM(QUANTITE_LIVRE * PRIX_UNITAIRE) AS total 
                 FROM vente_details 
                 WHERE ID_VENTE = ?", 
                [$venteId],
                true
            );
            
            $totalVente = $totalResult['total'] ?? 0;

            $this->Model->update(
                'vente_vente',
                ['ID_VENTE' => $venteId],
                [
                    'MONTANT_PAYE' => $totalVente,
                    'DATE_RETOUR' => date('Y-m-d')
                ]
            );
        }

        $message = $this->getSuccessAlert('Retour enregistré avec succès');
    } else {
        $message = $this->getErrorAlert('Aucun traitement effectué. Vérifiez les quantités saisies');
    }

    $this->session->set_flashdata('message', $message);
    redirect(base_url('vente/Retour_Vente'));
}

// Fonctions utilitaires pour les messages
private function getSuccessAlert($msg)
{
    return "<div class='alert alert-success' id='message'>
        $msg
        <button type='button' class='close' data-dismiss='alert'>&times;</button>
    </div>";
}

private function getErrorAlert($msg)
{
    return "<div class='alert alert-danger' id='message'>
        $msg
        <button type='button' class='close' data-dismiss='alert'>&times;</button>
    </div>";
}
}                        