<?php 
 /**
  * 
  */
 class Details extends CI_Controller
 {
  
  function __construct()
  {
    parent::__construct();
    $this->load->library('Mylibrary');
    $this->ci = & get_instance();
    $this->ci->load->library("user_agent");
    $this->Is_Connected();
    // $this->verification();

    }

  public function Is_Connected()
       {

       if (empty($this->session->userdata('SOCAR_ID_USER')))
        {
         redirect(base_url('Login/'));
        }
       }

       


  public function index($id)
  {
      $data['title'] = "Carnet de bord";


       $data['details']=$this->Model->getRequeteOne('SELECT PLAQUE_VEHICULE, voiture_vehicule_marque.DESCRIPTION AS MARQUE, voiture_vehicule_categorie.VEHICULE_CATEGORIE_DESCR, NUMERO_CHASSIS FROM `voiture_vehicules` JOIN voiture_vehicule_marque ON voiture_vehicule_marque.MARQUE_ID = voiture_vehicules.VEHICULE_ID JOIN voiture_vehicule_categorie ON voiture_vehicule_categorie.VEHICULE_CATEGORIE_ID = voiture_vehicules.VEHICULE_CATEGORIE_ID WHERE `VEHICULE_ID` ='.$id.' '); 
       $data['reparation']=$this->Model->getRequete('SELECT voiture_reparation.REPARATION_ID, `CONSOMATION_DATE`, voiture_garage.GARAGE_NOM, `MONTANT_CONSOMATION`, `NUM_GENERATED`, rh_employe.NOM, rh_employe.PRENOM FROM `voiture_reparation` JOIN voiture_garage ON voiture_garage.GARAGE_ID = voiture_reparation.GARAGE_ID JOIN rh_employe ON rh_employe.ID_EMPLOYE = voiture_reparation.CHAUFFEUR_ID WHERE `VEHICULE_ID` = 1 AND voiture_reparation.ID_STATUS = 1'); 
       $data['somereparation']=$this->Model->getRequeteOne('SELECT SUM(MONTANT_CONSOMATION) AS MONTANT_CONSOMATION FROM `voiture_reparation` WHERE `VEHICULE_ID` = 1 AND voiture_reparation.ID_STATUS = 1'); 
       $data['details_reparation']=$this->Model->getRequete('SELECT voiture_reparation.REPARATION_ID, voiture_piece.PIECE_NOM, REPARATION_FAITE, MONTANT_UNITAIRE FROM `voiture_reparation_details` JOIN voiture_reparation ON voiture_reparation.REPARATION_ID = voiture_reparation_details.REPARATION_ID JOIN voiture_piece ON voiture_piece.PIECE_ID = voiture_reparation_details.PIECE_ID WHERE 1 AND voiture_reparation.VEHICULE_ID = 1');
       $data['controle_technique']=$this->Model->getRequete('SELECT `DATE_DEBUT`,`DATE_FIN`, voiture_statut.DESCRIPTION AS ID_STATUS FROM `voiture_controle_technique` JOIN voiture_statut ON voiture_statut.ID_STATUS = voiture_controle_technique.ID_STATUS WHERE `VEHICULE_ID` = 1'); 
       $data['assurance']=$this->Model->getRequete('SELECT `DATE_DEBUT`,`DATE_FIN`, voiture_statut.DESCRIPTION AS ID_STATUS FROM `voiture_assurance` JOIN voiture_statut ON voiture_statut.ID_STATUS = voiture_assurance.ID_STATUS WHERE `VEHICULE_ID` = 1'); 
       
       $data['consomation']=$this->Model->getRequete('SELECT `CONSOMATION_DATE`, voiture_vehicules.PLAQUE_VEHICULE, `KM_A_APROVISIONNEMENT`, voiture_station.STATION_NOM, `QUANTITE_RECU`, `MONTANT_CONSOMATION`, `NUM_GENERATED`, `PATH_FACTURE`, voiture_statut.DESCRIPTION AS ID_STATUS, rh_employe.NOM, rh_employe.PRENOM FROM `voiture_carburant_consomation` JOIN voiture_vehicules ON voiture_vehicules.VEHICULE_ID = voiture_carburant_consomation.VEHICULE_ID JOIN voiture_station ON voiture_station.STATION_ID = voiture_carburant_consomation.STATION_ID JOIN rh_employe ON rh_employe.ID_EMPLOYE = voiture_carburant_consomation.CHAUFFEUR_ID JOIN voiture_statut ON voiture_statut.ID_STATUS = voiture_carburant_consomation.ID_STATUS WHERE voiture_carburant_consomation.VEHICULE_ID = 1 AND voiture_carburant_consomation.ID_STATUS = 1');
       $data['someconsomation']=$this->Model->getRequeteOne('SELECT SUM(MONTANT_CONSOMATION) AS MONTANT_CONSOMATION FROM `voiture_carburant_consomation`  WHERE voiture_carburant_consomation.VEHICULE_ID = 1 AND voiture_carburant_consomation.ID_STATUS = 1');
       $data['vidange']=$this->Model->getRequete('SELECT `CONSOMATION_DATE`,`KM_A_APROVISIONNEMENT`,  `KM_PROCHAIN`, `QUANTITE_RECU`, voiture_huile_moteur.DESCRIPTION AS HUILE_MOTEUR_ID,  `MONTANT_CONSOMATION`, voiture_vidange.PRIX_UNITAIRE, `NUM_GENERATED`, rh_employe.NOM, rh_employe.PRENOM FROM `voiture_vidange` JOIN voiture_huile_moteur ON voiture_huile_moteur.HUILE_MOTEUR_ID = voiture_vidange.HUILE_MOTEUR_ID JOIN rh_employe ON rh_employe.ID_EMPLOYE =voiture_vidange.CHAUFFEUR_ID WHERE `VEHICULE_ID` = 1 AND voiture_vidange.ID_STATUS = 1');
       $data['somevidange']=$this->Model->getRequeteOne('SELECT SUM(MONTANT_CONSOMATION) AS MONTANT_CONSOMATION FROM `voiture_vidange` WHERE `VEHICULE_ID` = 1 AND voiture_vidange.ID_STATUS = 1');


      $this->load->view("Details_View",$data);
  }



  public function save_controle_technique()
  {

        $DATE_DEBUT = DateTime::createFromFormat('d/m/Y', $this->input->post('DATE_DEBUT'));
        $DATE_DEBUT = $DATE_DEBUT->format('Y-m-d');


        $DATE_FIN = DateTime::createFromFormat('d/m/Y', $this->input->post('DATE_FIN'));
        $DATE_FIN = $DATE_FIN->format('Y-m-d');

        $browser=$this->ci->agent->browser.' version '.$this->ci->agent->version;
        $os=$this->ci->agent->platform;
        $ip = $_SERVER["REMOTE_ADDR"];
        $dt = new DateTime("now", new DateTimeZone('Africa/Bujumbura'));
        $new_dt = $dt->format('Y-m-d H:i:s');

    
        $title = "Enregistrement des Controle Technique";
        $NUM_GENERATED = $this->input->post('NUM_GENERATED');
        $approvisionnement = array(
               'VEHICULE_ID'=>$this->Model->getList('voiture_vehicules',array()), 
              );
    
     
     
     $data = array(          
        'VEHICULE_ID'=>$this->input->post('VEHICULE_ID'),  
        'DATE_DEBUT'=>$DATE_DEBUT,
        'DATE_FIN'=>$DATE_FIN,
        'ID_STATUS'=>1
        );

     $this->form_validation->set_rules('DATE_FIN', 'Date facturation', 'required');
     $this->form_validation->set_rules('DATE_DEBUT', 'Vehicule', 'required');
     $this->form_validation->set_rules('VEHICULE_ID', 'Garage', 'required');
     
     
     

    //SI Valide
     if ($this->form_validation->run() == FALSE){        
        
        $title = "Enregistrement des Controle Technique";

        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

        $data['title'] = $title;        
        $data['approv'] = $approvisionnement;
        $this->session->set_flashdata(array('message'=>$message));
       $this->load->view("Controle_Technique_Add_View",$data);

      }else{
        
        $this->Model->insert_last_id('voiture_controle_technique',$data);

          $message = "<div class='alert alert-success'  id='message'>
                            Enregistrement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Controle_Technique/'));
      }
  }



  public function listing()
    {
      
        $data['title'] = "Controle Technique des voitures";
        $this->load->view('Controle_Technique_List_View',$data);

    }

    public function verification()
    {
        $todaydate = date('Y-m-d'); 
        $liste = $this->Model->getRequete('SELECT ID_CONTROLE_TECHNIQUE FROM `voiture_controle_technique` WHERE 1 AND DATE_FIN < "'.$todaydate.'" AND ID_STATUS = 1');
        foreach ($liste as $key) {
          $this->Model->update('voiture_controle_technique',array('ID_CONTROLE_TECHNIQUE'=>$key['ID_CONTROLE_TECHNIQUE']),array('ID_STATUS'=>5));
        }
    }

 }                        