<?php 
 /**
  * 
  */
 class Vehicule extends CI_Controller
 {
  
  function __construct()
  {
    parent::__construct();
    $this->load->library('Mylibrary');
    $this->Is_Connected();

    }

  public function Is_Connected()
       {

       if (empty($this->session->userdata('SOCAR_ID_USER')))
        {
         redirect(base_url('Login/'));
        }
       }


  public function index()
  {
      
      $title = "Enregistrement des vehicules";
      
      $approvisionnement = array(
               'PLAQUE_VEHICULE'=>NULL,       
               'MARQUE_ID'=>$this->Model->getList('voiture_vehicule_marque',array('STATUS'=>1)), 
               'NUMERO_CHASSIS'=>NULL, 
               'VEHICULE_CATEGORIE_ID'=>$this->Model->getList('voiture_vehicule_categorie',array()),
              );

        
        $data['title'] = $title;
        $data['approv'] = $approvisionnement;
      $this->load->view("Vehicule_Add_View",$data);
  }

  public function enregistrer_vehicule()
  {
      $DESCRIPTION = $this->input->post('DESCRIPTION');

      $data_marq = array(
               'DESCRIPTION'=>$this->input->post('DESCRIPTION'),
              );
      $MARQUE_ID = $this->Model->insert_last_id('voiture_vehicule_marque',$data_marq);
      echo '<option value="'.$MARQUE_ID.'">'.$DESCRIPTION.'</option>';
  }


  public function enregistrer_usage()
  {
      $VEHICULE_CATEGORIE_DESCR = $this->input->post('VEHICULE_CATEGORIE_DESCR');

      $data_marq = array(
               'VEHICULE_CATEGORIE_DESCR'=>$this->input->post('VEHICULE_CATEGORIE_DESCR'),
              );
      $VEHICULE_CATEGORIE_ID = $this->Model->insert_last_id('voiture_vehicule_categorie',$data_marq);
      echo '<option value="'.$VEHICULE_CATEGORIE_ID.'">'.$VEHICULE_CATEGORIE_DESCR.'</option>';
  }



  

  public function save_vehicule()
  {
     $approvisionnement = array(          
        'PLAQUE_VEHICULE'=>$this->input->post('PLAQUE_VEHICULE'),                                 
        'MARQUE_ID'=>$this->Model->getList('voiture_vehicule_marque',array('STATUS'=>1)), 
        'NUMERO_CHASSIS'=>$this->input->post('NUMERO_CHASSIS'), 
        'VEHICULE_CATEGORIE_ID'=>$this->Model->getList('voiture_vehicule_categorie',array()),
        );

     $data = array(          
        'PLAQUE_VEHICULE'=>$this->input->post('PLAQUE_VEHICULE'),                                 
        'MARQUE_ID'=>$this->input->post('MARQUE_ID'),                                   
        'NUMERO_CHASSIS'=>$this->input->post('NUMERO_CHASSIS'),
        'VEHICULE_CATEGORIE_ID'=>$this->input->post('VEHICULE_CATEGORIE_ID'),
        );
     
     $this->form_validation->set_rules('PLAQUE_VEHICULE', 'Plaque', 'required');
     $this->form_validation->set_rules('NUMERO_CHASSIS', 'Chassis', 'required');
     $this->form_validation->set_rules('MARQUE_ID', 'Marque', 'required');
     $this->form_validation->set_rules('VEHICULE_CATEGORIE_ID', 'Categorie', 'required');
     
    //SI Valide
     if ($this->form_validation->run() == FALSE){        
        
        $title = "Enregistrement des vehicules";

        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

        $data['title'] = $title;        
        $data['approv'] = $approvisionnement;
        $this->session->set_flashdata(array('message'=>$message));
       $this->load->view("Vehicule_Add_View",$data);

      }else{
        $this->Model->insert_last_id('voiture_vehicules',$data);
        
          $message = "<div class='alert alert-success'  id='message'>
                            Enregistrement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/'));
      }
  }


  public function update_vehicule()
  {
      $title = "Modification des vehicules";
      $VEHICULE_ID =$this->input->post('VEHICULE_ID');
      $onedetail = $this->Model->getOne('voiture_vehicules',array('VEHICULE_ID'=>$VEHICULE_ID));
      $approvisionnement = array(
               'VEHICULE_ID'=>$onedetail['VEHICULE_ID'],
               'PLAQUE_VEHICULE'=>$onedetail['PLAQUE_VEHICULE'],       
               'MARQUE_ID'=>$this->Model->getList('voiture_vehicule_marque',array('STATUS'=>1)), 
               'NUMERO_CHASSIS'=>$onedetail['NUMERO_CHASSIS'], 
               'VEHICULE_CATEGORIE_ID'=>$this->Model->getList('voiture_vehicule_categorie',array()),
               'MARQUE_ID_SELECT'=>$onedetail['MARQUE_ID'], 
               'VEHICULE_CATEGORIE_ID_SELECT'=>$onedetail['VEHICULE_CATEGORIE_ID'],
              ); 

     $data = array(          
        'PLAQUE_VEHICULE'=>$this->input->post('PLAQUE_VEHICULE'),                                 
        'MARQUE_ID'=>$this->input->post('MARQUE_ID'),                                   
        'NUMERO_CHASSIS'=>$this->input->post('NUMERO_CHASSIS'),
        'VEHICULE_CATEGORIE_ID'=>$this->input->post('VEHICULE_CATEGORIE_ID'),
        );
     
     $this->form_validation->set_rules('PLAQUE_VEHICULE', 'Plaque', 'required');
     $this->form_validation->set_rules('NUMERO_CHASSIS', 'Chassis', 'required');
     $this->form_validation->set_rules('MARQUE_ID', 'Marque', 'required');
     $this->form_validation->set_rules('VEHICULE_CATEGORIE_ID', 'Categorie', 'required');
     
    //SI Valide
     if ($this->form_validation->run() == FALSE){        
        

        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

        $data['title'] = $title;        
        $data['approv'] = $approvisionnement;
        $this->session->set_flashdata(array('message'=>$message));
       $this->load->view("Vehicule_Update_View",$data);

      }else{
        $this->Model->update('voiture_vehicules',array('VEHICULE_ID'=>$VEHICULE_ID),$data);
        
          $message = "<div class='alert alert-success'  id='message'>
                            Enregistrement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listing'));
      }
  }



  public function listing()
    {

      $data['resultat']=$this->Model->getRequete('SELECT voiture_vehicules.VEHICULE_ID, voiture_vehicules.PLAQUE_VEHICULE, voiture_vehicule_marque.DESCRIPTION, voiture_vehicules.NUMERO_CHASSIS, VEHICULE_CATEGORIE_DESCR FROM `voiture_vehicules` JOIN voiture_vehicule_marque on voiture_vehicule_marque.MARQUE_ID = voiture_vehicules.MARQUE_ID JOIN voiture_vehicule_categorie on voiture_vehicule_categorie.VEHICULE_CATEGORIE_ID = voiture_vehicules.VEHICULE_CATEGORIE_ID');
      

        $data['title'] = "Liste des vehicules";
        $this->load->view('Vehicule_List_View',$data);

    }

  public function modifier()
  {
      $title = "Modification des vehicules";
      $VEHICULE_ID =$this->uri->segment(4);
      $onedetail = $this->Model->getOne('voiture_vehicules',array('VEHICULE_ID'=>$VEHICULE_ID));
      $approvisionnement = array(
               'VEHICULE_ID'=>$onedetail['VEHICULE_ID'],
               'PLAQUE_VEHICULE'=>$onedetail['PLAQUE_VEHICULE'],       
               'MARQUE_ID'=>$this->Model->getList('voiture_vehicule_marque',array('STATUS'=>1)), 
               'NUMERO_CHASSIS'=>$onedetail['NUMERO_CHASSIS'], 
               'VEHICULE_CATEGORIE_ID'=>$this->Model->getList('voiture_vehicule_categorie',array()),
               'MARQUE_ID_SELECT'=>$onedetail['MARQUE_ID'], 
               'VEHICULE_CATEGORIE_ID_SELECT'=>$onedetail['VEHICULE_CATEGORIE_ID'],
              ); 
    
        
        $data['title'] = $title;
        $data['approv'] = $approvisionnement;


    $this->load->view("Vehicule_Update_View",$data);
  }

 

 
public function listingmarque()
    {

      $data['resultat']=$this->Model->getRequete('SELECT * from voiture_vehicule_marque');
      
      // $tabledata=array();
      
      

      //   $template = array(
      //       'table_open' => '<table id="mytable" class="table table-bordered table-striped">',
      //       'table_close' => '</table>'
      //   );
        // $this->table->set_template($template);
        // $this->table->set_heading(array('#','Marque','Status','Options'));
        // $data['employe']=$tabledata;
        $data['title'] = "Liste des Marque des vehicules";
        // $data['menus'] = array('menu2'=>'','menu3'=>'btn-primary','menu4'=>'');
        $this->load->view('Vehicule_Marque_List_View',$data);

    }


    public function markdeclasser()
  {
    $MARQUE_ID = $this->uri->segment(4);
    $detail = $this->Model->update('voiture_vehicule_marque',array('MARQUE_ID'=>$MARQUE_ID),array('STATUS'=>0));

    $message = "<div class='alert alert-success'  id='message'>
                            Declassement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listingmarque'));
  }

  public function markreclasser()
  {
    $MARQUE_ID = $this->uri->segment(4);
    $detail = $this->Model->update('voiture_vehicule_marque',array('MARQUE_ID'=>$MARQUE_ID),array('STATUS'=>1));

    $message = "<div class='alert alert-success'  id='message'>
                            Reclassement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listingmarque'));
  }


  public function update_marque()
  {

    $DESCRIPTION =$this->input->post('DESCRIPTION');
    $MARQUE_ID =$this->input->post('val');

    
     $data = array('DESCRIPTION'=>$this->input->post('DESCRIPTION'));

     
     
     $this->form_validation->set_rules('DESCRIPTION', 'Nom du Marque', 'required');
    //SI Valide
     if ($this->form_validation->run() == FALSE){      
        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listingmarque'));

      }else{
        $this->Model->update('voiture_vehicule_marque',array('MARQUE_ID'=>$MARQUE_ID),$data);
        
          $message = "<div class='alert alert-success'  id='message'>
                            Modification fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listingmarque'));
      }
  }


   public function listingcat()
    {

      $data['resultat']=$this->Model->getRequete('SELECT * from voiture_vehicule_categorie');
      
      $tabledata=array();
      
      

        $template = array(
            'table_open' => '<table id="mytable" class="table table-bordered table-striped">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('#','Usage','Status','Options'));
        $data['employe']=$tabledata;
        $data['title'] = "Liste des Usage des vehicule";
        $data['menus'] = array('menu2'=>'','menu3'=>'','menu4'=>'btn-primary');
        $this->load->view('Vehicule_Categorie_List_View',$data);

    }


    public function catdeclasser()
  {
    $VEHICULE_CATEGORIE_ID = $this->uri->segment(4);
    $detail = $this->Model->update('voiture_vehicule_categorie',array('VEHICULE_CATEGORIE_ID'=>$VEHICULE_CATEGORIE_ID),array('STATUS'=>0));

    $message = "<div class='alert alert-success'  id='message'>
                            Declassement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listingcat'));
  }


  public function catreclasser()
  {
    $VEHICULE_CATEGORIE_ID = $this->uri->segment(4);
    $detail = $this->Model->update('voiture_vehicule_categorie',array('VEHICULE_CATEGORIE_ID'=>$VEHICULE_CATEGORIE_ID),array('STATUS'=>1));

    $message = "<div class='alert alert-success'  id='message'>
                            Declassement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listingcat'));
  }



  public function update_category()
  {

    $VEHICULE_CATEGORIE_DESCR =$this->input->post('VEHICULE_CATEGORIE_DESCR');
    $VEHICULE_CATEGORIE_ID =$this->input->post('val');

    
     $data = array(          
        'VEHICULE_CATEGORIE_DESCR'=>$this->input->post('VEHICULE_CATEGORIE_DESCR'),                            
        );

     
     
     $this->form_validation->set_rules('VEHICULE_CATEGORIE_DESCR', 'Usage', 'required');
      
    //SI Valide
     if ($this->form_validation->run() == FALSE){      
        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listingcat'));

      }else{
        $this->Model->update('voiture_vehicule_categorie',array('VEHICULE_CATEGORIE_ID'=>$VEHICULE_CATEGORIE_ID),$data);
        
          $message = "<div class='alert alert-success'  id='message'>
                            Modification fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Vehicule/listingcat'));
      }
  }
 

 }


?>