<?php 
 /**
  * 
  */
 class Garage extends CI_Controller
 {
  
  function __construct()
  {
    parent::__construct();
    $this->load->library('Mylibrary');
    $this->ci = & get_instance();
    $this->ci->load->library("user_agent");
    $this->Is_Connected();
    $this->verification();

    }

  public function Is_Connected()
       {

       if (empty($this->session->userdata('SOCAR_ID_USER')))
        {
         redirect(base_url('Login/'));
        }
       }

       


  public function index()
  {
      $title = "Enregistrement Garage";

      
        $data['province']=$this->Model->getList('syst_provinces',array());
        $data['commune']=$this->Model->getList('syst_communes',array());
        $data['title'] = $title;
      $this->load->view("Garage_Add_View",$data);
  }

  function get_commune($prov){
    $comm = $this->Model->getList('syst_communes',array('PROVINCE_ID'=>$prov));
    $html = '<option value="" > --- </option>';
    foreach ($comm as $comm) {
      $html .= '<option value="'.$comm['COMMUNE_ID'].'">'.$comm['COMMUNE_NAME'].'</option>';
    }
    echo $html;

  }


  public function save_garage()
  {

     $data = array(          
        'GARAGE_NOM'=>$this->input->post('GARAGE_NOM'),  
        'PROVINCE_ID'=>$this->input->post('PROVINCE_ID'),  
        'COMMUNE_ID'=>$this->input->post('COMMUNE_ID'), 
        );

     $this->form_validation->set_rules('GARAGE_NOM', 'Nom du garage', 'required');
     $this->form_validation->set_rules('PROVINCE_ID', 'Province', 'required');
     $this->form_validation->set_rules('COMMUNE_ID', 'Commune', 'required');
     
    //SI Valide
     if ($this->form_validation->run() == FALSE){        
        
      $title = "Enregistrement Garage";

      
      $data['province']=$this->Model->getList('syst_provinces',array());
      $data['commune']=$this->Model->getList('syst_communes',array());
      $data['title'] = $title;
    // $this->load->view("Garage_Add_View",$data);

        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

        
        $this->session->set_flashdata(array('message'=>$message));
       $this->load->view("Garage_Add_View",$data);

      }else{
        
        $this->Model->insert_last_id('voiture_garage',$data);

          $message = "<div class='alert alert-success'  id='message'>
                            Enregistrement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Garage/'));
      }
  }



  public function listing()
    {
      
        $data['title'] = "Garages des voitures";
        $this->load->view('Garage_List_View',$data);

    }

    public function verification()
    {
        $todaydate = date('Y-m-d'); 
        $liste = $this->Model->getRequete('SELECT ID_ASSURANCE FROM `voiture_assurance` WHERE 1 AND DATE_FIN < "'.$todaydate.'" AND ID_STATUS = 1');
        foreach ($liste as $key) {
          $this->Model->update('voiture_assurance',array('ID_ASSURANCE'=>$key['ID_ASSURANCE']),array('ID_STATUS'=>5));
        }
    }


    public function modifier()
  {
      $title = "Modification Garage";
      $GARAGE_ID =$this->uri->segment(4);
      $onedetail = $this->Model->getOne('voiture_garage',array('GARAGE_ID'=>$GARAGE_ID));
      $approvisionnement = array(
               'GARAGE_ID'=>$onedetail['GARAGE_ID'],
               'GARAGE_NOM'=>$onedetail['GARAGE_NOM'],       
               'PROVINCE_ID'=>$onedetail['PROVINCE_ID'],       
               'COMMUNE_ID'=>$onedetail['COMMUNE_ID'],       
               'province'=>$this->Model->getList('syst_provinces',array()),
               'commune'=>$this->Model->getList('syst_communes',array()),
              ); 
    
        
        $data['title'] = $title;
        $data['approv'] = $approvisionnement;


    $this->load->view("Garage_Update_View",$data);
  }

  public function update_garage()
  {

     $data = array(          
        'GARAGE_NOM'=>$this->input->post('GARAGE_NOM'),  
        'PROVINCE_ID'=>$this->input->post('PROVINCE_ID'),  
        'COMMUNE_ID'=>$this->input->post('COMMUNE_ID'), 
        );

     $this->form_validation->set_rules('GARAGE_NOM', 'Nom du garage', 'required');
     $this->form_validation->set_rules('PROVINCE_ID', 'Province', 'required');
     $this->form_validation->set_rules('COMMUNE_ID', 'Commune', 'required');
     $title = "Modification Garage";
     $GARAGE_ID =$this->input->post('GARAGE_ID');
     
    //SI Valide
     if ($this->form_validation->run() == FALSE){        
        
      
      // echo $GARAGE_ID;
      // 
      $onedetail = $this->Model->getOne('voiture_garage',array('GARAGE_ID'=>$GARAGE_ID));
      // print_r($onedetail);
      // exit();
      $approvisionnement = array(
               'GARAGE_ID'=>$onedetail['GARAGE_ID'],
               'GARAGE_NOM'=>$onedetail['GARAGE_NOM'],       
               'PROVINCE_ID'=>$onedetail['PROVINCE_ID'],       
               'COMMUNE_ID'=>$onedetail['COMMUNE_ID'],       
               'province'=>$this->Model->getList('syst_provinces',array()),
               'commune'=>$this->Model->getList('syst_communes',array()),
              ); 
    
        
        $data['title'] = $title;
        $data['approv'] = $approvisionnement;


    // $this->load->view("Garage_Update_View",$data);

        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

        
        $this->session->set_flashdata(array('message'=>$message));
       $this->load->view("Garage_Update_View",$data);

      }else{
        
        $this->Model->update('voiture_garage',array('GARAGE_ID'=>$GARAGE_ID),$data);

          $message = "<div class='alert alert-success'  id='message'>
                            Enregistrement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Garage/listing'));
      }
  }

 }                        