<?php
include VIEWPATH.'includes/new_header.php';
?>

<body class="hold-transition sidebar-mini">
  <!-- Site wrapper -->
  <div class="wrapper">
    <?php
    include VIEWPATH.'includes/new_top_menu.php';
    include VIEWPATH.'includes/new_menu_principal.php';
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <?php include 'includes/menu_type_bouteille.php'; ?>

      <!-- Main content -->
      <section class="content">

        <!-- Default box -->
        <div class="card">

        <?php 
             if(!empty($this->session->flashdata('message')))
               echo $this->session->flashdata('message');
            ?>
          <div class="card card-primary">
            <div class="card-header">
              <h3 class="card-title">Enregistrement taille bouteille</h3>
            </div>
            <!-- /.card-header -->
            

           
            <!-- form start -->
            <form id="FormData" action="<?php echo base_url() ?>configuration/Type_Bouteille/add" method="POST" enctype="multipart/form-data">
              <div class="card-body row">
                <div class="form-group col-lg-12">
                  <label for="DESCRIPTION">Taille de la bouteille <span class="text-danger">*</span></label>
                  <input type="text" class="form-control" id="DESCRIPTION" name="DESCRIPTION" placeholder="500ml" value="<?= set_value('DESCRIPTION') ?>">
                  <?php echo form_error('DESCRIPTION', '<div class="text-danger">', '</div>'); ?>
                </div>

                <div class="form-group col-lg-4">
                  <label for="LIMITE_VIDE">Seuil limite des bouteille vide <span class="text-danger">*</span></label>
                  <input type="number" class="form-control" id="LIMITE_VIDE" name="LIMITE_VIDE" placeholder="500" value="<?= set_value('LIMITE_VIDE') ?>">
                  <?php echo form_error('LIMITE_VIDE', '<div class="text-danger">', '</div>'); ?>
                </div>

                <div class="form-group col-lg-4">
                  <label for="LIMITE_PLEIN">Seuil limite des bouteille Remplie <span class="text-danger">*</span></label>
                  <input type="number" class="form-control" id="LIMITE_PLEIN" name="LIMITE_PLEIN" placeholder="1000" value="<?= set_value('LIMITE_PLEIN') ?>">
                  <?php echo form_error('LIMITE_PLEIN', '<div class="text-danger">', '</div>'); ?>
                </div>

                <div class="form-group col-lg-4">
                  <label for="QUANTITE_LITRE">Quantités litre <span class="text-danger">*</span></label>
                  <input type="number" step="0.01" class="form-control" id="QUANTITE_LITRE" name="QUANTITE_LITRE" placeholder="1000" value="<?= set_value('QUANTITE_LITRE') ?>">
                  <?php echo form_error('QUANTITE_LITRE', '<div class="text-danger">', '</div>'); ?>
                </div>
                <div class="col-md-12"><h4><lead>Les Prix</lead></h4></div>
                <div class="form-group col-lg-12 row">
                  <div class="form-group col-lg-4">
                    <label>Type de prix</label>
                    <select name="prix" class="form-control" id="prixSelect">
                      <?php
                      $verif = $this->Model->getRequete('SELECT * FROM `standard_status`');
                      foreach ($verif as $value) {
                      ?>
                        <option value="<?= $value['ID_STANDARD'] ?>" ><?= $value['DESCRIPTION'] ?></option>
                      <?php
                      }
                      ?>
                    </select>
                  </div>

                  <div class="form-group col-lg-4">
                    <label>Montant:</label>
                    <input type="number" class="form-control" name="montant" id="montantInput">
                  </div>

                  <div class="form-group col-lg-4">
                    <button type="button" class="btn btn-info" id="btn_add_cart" style="margin-top: 30px;">Ajouter</button>
                  </div>
                </div>
              </div>

              <div class="card-body">
                <div class="form-group col-lg-4">
                  <!-- Conteneur pour afficher le contenu du panier -->
                  <div id="cartContainer">
                    <h4>Nos prix</h4>
                    <div id="cartItems"></div> <!-- Les articles du panier seront ajoutés ici -->
                  </div>
                </div>
              </div>

              <div class="card-footer">
                <button type="submit" class="btn btn-primary btn-block">Enregistrer</button>
              </div>
            </form>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->

      </section>
      <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <?php include VIEWPATH.'includes/new_copy_footer.php'; ?>
    <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->
  <?php include VIEWPATH.'includes/new_script.php'; ?>


<script>
  $(document).ready(function() {
    $('#message').delay(5000).hide('slow');
    $('#cartContainer').hide();

    // Ajouter un article au panier
    $('#btn_add_cart').on('click', function() {
      var prixId = $('#prixSelect').val();
      var montant = $('#montantInput').val();
      var montantOption = $('#prixSelect option:selected').data('price'); // Récupérer le prix associé

      $.ajax({
        url: '<?php echo base_url("configuration/Type_Bouteille/add_to_cart"); ?>',
        method: 'POST',
        data: {
          prix: prixId,
          montant: montant,
          montant_option: montantOption
        },
        success: function() {
          updateCart();
          $('#cartContainer').show();
        },
        error: function() {
          console.log('Une erreur est survenue lors de l\'ajout au panier.');
        }
      });
    });

    // Mettre à jour le panier
    function updateCart() {
      $.ajax({
        url: '<?php echo base_url("configuration/Type_Bouteille/view_cart"); ?>',
        method: 'GET',
        success: function(data) {
          $('#cartItems').html(data); // Afficher le contenu du panier
          $('#cartContainer').show();
          
          // Gestionnaire d'événements pour les boutons de suppression
          $('.btn-remove').off('click').on('click', function(event) {
            event.preventDefault(); // Empêcher la soumission du formulaire
            var rowid = $(this).data('rowid'); // Récupérer l'ID de la ligne
            removeFromCart(rowid);
          });
        }
      });
    }

    // Supprimer un article du panier
    function removeFromCart(rowid) {
      $.ajax({
        url: '<?php echo base_url("configuration/Type_Bouteille/remove_from_cart"); ?>',
        method: 'POST',
        data: { rowid: rowid },
        success: function() {
          updateCart(); // Mettre à jour le panier
        },
        error: function() {
          console.log('Une erreur est survenue lors de la suppression de l\'article.');
        }
      });
    }

    // Vider le panier
    $('#btn_clear_cart').on('click', function(event) {
      event.preventDefault(); // Empêcher la soumission du formulaire
      $.ajax({
        url: '<?php echo base_url("configuration/Type_Bouteille/clear_cart"); ?>',
        method: 'POST',
        success: function() {
          updateCart(); // Mettre à jour le panier
        },
        error: function() {
          console.log('Une erreur est survenue lors de la vidange du panier.');
        }
      });
    });
  });
</script>
</body>
</html>