<?php 
 /**
  * 
  */
 class Controle_Technique extends CI_Controller
 {
  
  function __construct()
  {
    parent::__construct();
    $this->load->library('Mylibrary');
    $this->ci = & get_instance();
    $this->ci->load->library("user_agent");
    $this->Is_Connected();
    $this->verification();

    }

  public function Is_Connected()
       {

       if (empty($this->session->userdata('SOCAR_ID_USER')))
        {
         redirect(base_url('Login/'));
        }
       }

       


  public function index()
  {
      $title = "Enregistrement Controle Technique";

      $NUM_GENERATED = $this->notifications->generate_UIID(10);

      $approvisionnement = array(
               'VEHICULE_ID'=>$this->Model->getList('voiture_vehicules',array()), 
              );

        $data['title'] = $title;
        $data['approv'] = $approvisionnement;
      $this->load->view("Controle_Technique_Add_View",$data);
  }



  public function save_controle_technique()
  {

        $DATE_DEBUT = DateTime::createFromFormat('d/m/Y', $this->input->post('DATE_DEBUT'));
        $DATE_DEBUT = $DATE_DEBUT->format('Y-m-d');


        $DATE_FIN = DateTime::createFromFormat('d/m/Y', $this->input->post('DATE_FIN'));
        $DATE_FIN = $DATE_FIN->format('Y-m-d');

        $browser=$this->ci->agent->browser.' version '.$this->ci->agent->version;
        $os=$this->ci->agent->platform;
        $ip = $_SERVER["REMOTE_ADDR"];
        $dt = new DateTime("now", new DateTimeZone('Africa/Bujumbura'));
        $new_dt = $dt->format('Y-m-d H:i:s');

    
        $title = "Enregistrement des Controle Technique";
        $NUM_GENERATED = $this->input->post('NUM_GENERATED');
        $approvisionnement = array(
               'VEHICULE_ID'=>$this->Model->getList('voiture_vehicules',array()), 
              );
    
     
     
     $data = array(          
        'VEHICULE_ID'=>$this->input->post('VEHICULE_ID'),  
        'DATE_DEBUT'=>$DATE_DEBUT,
        'DATE_FIN'=>$DATE_FIN,
        'ID_STATUS'=>1
        );

     $this->form_validation->set_rules('DATE_FIN', 'Date facturation', 'required');
     $this->form_validation->set_rules('DATE_DEBUT', 'Vehicule', 'required');
     $this->form_validation->set_rules('VEHICULE_ID', 'Garage', 'required');
     
     
     

    //SI Valide
     if ($this->form_validation->run() == FALSE){        
        
        $title = "Enregistrement des Controle Technique";

        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

        $data['title'] = $title;        
        $data['approv'] = $approvisionnement;
        $this->session->set_flashdata(array('message'=>$message));
       $this->load->view("Controle_Technique_Add_View",$data);

      }else{
        
        $this->Model->insert_last_id('voiture_controle_technique',$data);

          $message = "<div class='alert alert-success'  id='message'>
                            Enregistrement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Controle_Technique/'));
      }
  }



  public function listing()
    {
      
        $data['title'] = "Controle Technique des voitures";
        $this->load->view('Controle_Technique_List_View',$data);

    }

    public function verification()
    {
        $todaydate = date('Y-m-d'); 
        $liste = $this->Model->getRequete('SELECT ID_CONTROLE_TECHNIQUE FROM `voiture_controle_technique` WHERE 1 AND DATE_FIN < "'.$todaydate.'" AND ID_STATUS = 1');
        foreach ($liste as $key) {
          $this->Model->update('voiture_controle_technique',array('ID_CONTROLE_TECHNIQUE'=>$key['ID_CONTROLE_TECHNIQUE']),array('ID_STATUS'=>5));
        }
    }

 }                        