<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pdf_Remise extends CI_Controller {

    function __construct() {
        parent::__construct();
    }
    
    public function index($id){

      // echo "string";
      // exit();
      include 'pdfinclude/fpdf/mc_table.php';
      include 'pdfinclude/fpdf/pdf_config.php';


      $pdf = new PDF_CONFIG('P','mm','A4');
      $pdf->addPage();
      // $pdf->Ln(20);

      $urlpass = base_url();
      $pdf->Image(''.$urlpass.'/upload/king.png', 5, 10, 100, 15, 'PNG');
      $pdf->Ln(15); 
    $pdf->Cell(5,5,'NIF',0,1,'L');
    $pdf->Cell(5,5,'TEL',0,1,'L');
    $pdf->Cell(5,5,'E-mail',0,1,'L');
    $pdf->Cell(5,5,'Adresse',0,0,'L');
    // Saut de ligne
    $pdf->Ln(10);
    
      $pdf->SetFont('Arial','B',15);



      // $pdf->SetX(10);
      $pdf->Cell(190,5,utf8_decode(strtoupper('REMISE ET REPRISE (Stock - Bar)')),0,1,'C');


      $pdf->SetFont('Arial','',10);




      $details=$this->Model->getRequeteOne('SELECT ID_REMISE_REPRISE, ID_COLLABO_ENTRANT, ent.COLLABORATEUR_NOM AS NOMENT, ent.COLLABORATEUR_PRENOM AS PRENOMENT, ID_COLLABO_SORTANT, sor.COLLABORATEUR_NOM NOMSOR, sor.COLLABORATEUR_PRENOM AS PRENOMSOR, DATE_HEURE_REMISE, TOTAL_VENTE, TOTAL_DETTE, TOTAL_LIQUIDITE, IF(IS_ACCEPTER =1, "Accepte", "Non Accepte") AS IS_ACCEPTER, stock_remise_reprise.COMMENTAIRE FROM `stock_remise_reprise` JOIN admin_collaborateurs as ent ON ent.COLLABORATEUR_ID = stock_remise_reprise.ID_COLLABO_ENTRANT JOIN admin_collaborateurs AS sor ON sor.COLLABORATEUR_ID = stock_remise_reprise.ID_COLLABO_SORTANT WHERE 1 AND ID_REMISE_REPRISE = '.$id.' ');

      

      $pdf->Ln(4);
      $pdf->SetX(10);
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(40,6,utf8_decode('Remettant'),0,0,'L');
      $pdf->SetFont('Arial','B',10);
      $pdf->Cell(40,6,utf8_decode($details['NOMSOR'].' '.$details['PRENOMSOR']),0,0,'L');
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(40,6,utf8_decode('Recevant'),0,0,'L');
      $pdf->SetFont('Arial','B',10);
      $pdf->Cell(40,6,utf8_decode($details['NOMENT'].' '.$details['PRENOMENT']),0,1,'L');
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(40,6,utf8_decode('le'),0,0,'L');
      $pdf->SetFont('Arial','B',10);
      $pdf->Cell(40,6,utf8_decode($details['DATE_HEURE_REMISE']),0,1,'L');
      

      $pdf->Ln(10);
      $pdf->SetX(11);
      $pdf->SetFont('Arial','B',10);
      $pdf->Cell(180,5,utf8_decode(strtoupper('Details')),0,1,'C');
      

      $pdf->Cell(60,6,utf8_decode('Description'),1,0,'L');
      $pdf->Cell(24,6,utf8_decode('Initiale'),1,0,'L');
      $pdf->Cell(24,6,utf8_decode('Entree'),1,0,'L');
      $pdf->Cell(24,6,utf8_decode('Final'),1,0,'L');
      $pdf->Cell(24,6,utf8_decode('Sortie'),1,0,'L');
      $pdf->Cell(24,6,utf8_decode('Restant'),1,1,'L');
      
      // $pdf->Cell(55,6,utf8_decode('Prénom'),0,0,'L');
      // $pdf->Cell(100,6,utf8_decode(':______ '),0,1,'L');
      $resultatsection=$this->Model->getRequete('SELECT * FROM `masque_section`');
      foreach ($resultatsection as $keysection) 
         {
            $resultat=$this->Model->getRequete('SELECT masque_produit.DESCRIPTION, stock_remise_reprise_details.QTEINITIALE, stock_remise_reprise_details.QTEENTREE, stock_remise_reprise_details.QTEFINAL, stock_remise_reprise_details.QTESORTIE, stock_remise_reprise_details.QTERESTANT FROM stock_remise_reprise_details JOIN masque_produit ON masque_produit.PRODUIT_ID = stock_remise_reprise_details.PRODUIT_ID WHERE stock_remise_reprise_details.ID_REMISE_REPRISE = '.$id.' AND masque_produit.SECTION_ID = '.$keysection['SECTION_ID'].'');
            if (!empty($resultat)) {
                $pdf->SetFont('Arial','B',11);
      $pdf->Cell(180,6,utf8_decode($keysection['DESCRIPTION']),1,1,'C');
      $pdf->SetFont('Arial','',10);
            }
            
      
      foreach ($resultat as $key) 
         {


      $pdf->Cell(60,6,utf8_decode($key['DESCRIPTION']),1,0,'L');
      $pdf->Cell(24,6,utf8_decode($key['QTEINITIALE']),1,0,'L');
      $pdf->Cell(24,6,utf8_decode($key['QTEENTREE']),1,0,'L');
      $pdf->Cell(24,6,utf8_decode($key['QTEFINAL']),1,0,'L');
      $pdf->Cell(24,6,utf8_decode($key['QTESORTIE']),1,0,'L');
      $pdf->Cell(24,6,utf8_decode($key['QTERESTANT']),1,1,'L');
     }

 }


      $pdf->Ln(5);
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(40,6,utf8_decode('Total Vente'),0,0,'L');
      $pdf->SetFont('Arial','B',10);
      $pdf->Cell(40,6,utf8_decode($details['TOTAL_VENTE']),0,1,'L');
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(40,6,utf8_decode('Total Dette'),0,0,'L');
      $pdf->SetFont('Arial','B',10);
      $pdf->Cell(40,6,utf8_decode($details['TOTAL_DETTE']),0,0,'L');
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(40,6,utf8_decode('Total Liquidite'),0,0,'L');
      $pdf->SetFont('Arial','B',10);
      $pdf->Cell(40,6,utf8_decode($details['TOTAL_LIQUIDITE']),0,1,'L');




      $pdf->Ln(15);
      $pdf->SetX(10);
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(55,6,utf8_decode('Status de la remise:'),0,0,'L');
      $pdf->SetFont('Arial','B',10);
      $pdf->Cell(100,6,utf8_decode($details['IS_ACCEPTER']),0,1,'L');
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(55,6,utf8_decode('Commentaire'),0,0,'L');
      // $pdf->MultiCell(float w, float h, string txt [, mixed border [, string align [, boolean fill]]])

      $pdf->SetFont('Arial','',10);
      $pdf->MultiCell( 130, 4, $details['COMMENTAIRE'], 0);
      // $pdf->Cell(100,6,utf8_decode($details['COMMENTAIRE']),0,1,'L');



      $pdf->Ln(10);
      $pdf->SetX(20);
      $pdf->SetFont('Arial','',10);
      $pdf->Cell(160,6,utf8_decode('Signature '),0,1,'C');
      $pdf->Cell(80,6,utf8_decode($details['NOMSOR'].' '.$details['PRENOMSOR']),0,0,'L');
      // $pdf->Cell(55,6,utf8_decode(''),0,0,'L');
      // $pdf->SetFont('Arial','B',10);
      $pdf->Cell(80,6,utf8_decode($details['NOMENT'].' '.$details['PRENOMENT']),0,1,'R');


     

      $pdf->Output('pdf_remise_'.$id.'.pdf','I');

    }


    

    
}
