<?php
class Employes  extends CI_Controller{
    function __construct() {
        parent::__construct();
        $this->Is_Connected();

      }

      public function Is_Connected()
       {

       if (empty($this->session->userdata('PEA_USER_ID')))
        {
         redirect(base_url('Login/'));
        }
       }

          public function Is_permis()
       {

       if ($this->mylibrary->get_permission('Employes') ==0)
        {
         redirect(base_url('Login/'));
        }
       }


    function index()
    {

      $this->Is_permis();
      $data['title'] = "Un nouveau Employé";
      $data['stitle'] = "Un nouveau Employé";
      $data['profiles'] = $this->Model->getList("admin_profils");
      $data['hierarchie'] = $this->Model->getList("admin_hierarchie");
      $data['sexe'] = $this->Model->getList("admin_sexe");
      $data['SEXE_ID']=0;
      $data['PROFIL_ID']=0;
      $data['HIERARCHIE_ID']=0;
      $this->load->view('Employes_Add_View',$data);
      
      }


    public function check_date()
     {

      $date_naissance=$this->input->post('DATE_DEBUT');
      $date_aujourdui=date('Y-m-d');
      if ($date_naissance > $date_aujourdui)
        {
         $this->form_validation->set_message('check_date', 'Date de naissance ('.$date_naissance.') doit être inférieure à la date d\'embauche ('.$date_aujourdui.')');
         return FALSE;
        }

        else
        {
        return TRUE;  
        }
      }


      public function check_tel1()
        {

        $id=$this->input->post('COLLABORATEUR_ID');
        $info_collabo=$this->Model->getOne('admin_collaborateurs',array('COLLABORATEUR_ID'=>$id));
        $phone1=$this->input->post('COLLABORATEUR_TEL');
        if ($info_collabo['COLLABORATEUR_TEL']!=$phone1)
         {
          $new_info_collabo=$this->Model->getOne('admin_collaborateurs',array('COLLABORATEUR_TEL'=>$phone1));
          if (!empty($new_info_collabo)) 
          {

          $this->form_validation->set_message('check_tel1', 'Ce numéro existe déjà');
           return FALSE;
          }
          else
          {
          return TRUE;
          }
         }
         else
         {
         return TRUE; 
         }

        }


        public function check_mail()
        {

        $id=$this->input->post('COLLABORATEUR_ID');
        $info_collabo=$this->Model->getOne('admin_collaborateurs',array('COLLABORATEUR_ID'=>$id));
        $EMAIL=$this->input->post('EMAIL');
        if (!empty($EMAIL))
         {
      
        if ($info_collabo['EMAIL']!=$EMAIL)
         {
          $new_info_collabo=$this->Model->getOne('admin_collaborateurs',array('EMAIL'=>$EMAIL));
          if (!empty($new_info_collabo)) 
          {

          $this->form_validation->set_message('check_mail', 'Ce mail existe déjà');
           return FALSE;
          }
          else
          {
          return TRUE;
          }
         }
         else
         {
         return TRUE; 
         }

        }

      }



    public function add(){


      $this->form_validation->set_rules('COLLABORATEUR_NOM','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">Le nom du collaborateur  est obligatoire</font>'));

      $this->form_validation->set_rules('COLLABORATEUR_PRENOM','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">Le prénom est obligatoire</font>'));

      $this->form_validation->set_rules('COLLABORATEUR_CNI','', 'trim|required|is_unique[admin_collaborateurs.COLLABORATEUR_CNI]',array('required'=>'<font style="color:red;size:2px;">Le CNI est obligatoire</font>','is_unique'=>'<font style="color:red;size:2px;">Le CNI est unique</font>'));

      $EMAIL=$this->input->post('EMAIL');
      if (!empty($EMAIL))
      {
       $this->form_validation->set_rules('EMAIL','', 'trim|required|is_unique[admin_collaborateurs.EMAIL]',array('is_unique'=>'<font style="color:red;size:2px;">Le mail est unique</font>'));
      }

      $this->form_validation->set_rules('COLLABORATEUR_TEL','', 'trim|required|is_unique[admin_collaborateurs.COLLABORATEUR_TEL]',array('required'=>'<font style="color:red;size:2px;">Le téléphone est obligatoire</font>','is_unique'=>'<font style="color:red;size:2px;">Le téléphone est unique</font>'));

      $this->form_validation->set_rules('ADRESSE_ACTUEL','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">L\'adresse de résidence est obligatoire</font>'));

      $this->form_validation->set_rules('HIERARCHIE_ID','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">L\'hiérarchie est obligatoire</font>'));

      $this->form_validation->set_rules('DATE_NAISSANCE', '', 'trim|required',array("required"=>"<font color='red'>La date de naissance est obligatoire</font>"));

      $this->form_validation->set_rules('SEXE_ID', '', 'trim|required',array("required"=>"<font color='red'>Le genre est obligatoire</font>"));

      $PROFIL_ID=$this->input->post('PROFIL_ID');
      if (!empty($PROFIL_ID))
       {
        $this->form_validation->set_rules('PROFIL_ID','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">Le profil est obligatoire</font>'));
       }


     if ($this->form_validation->run() == FALSE)
        { 
          
      $data['title'] = "Un nouveau Employé";
      $data['stitle'] = "Un nouveau Employé";
      $data['profiles'] = $this->Model->getList("admin_profils");
      $data['hierarchie'] = $this->Model->getList("admin_hierarchie");
      $data['PROFIL_ID']=$this->input->post('PROFIL_ID');
      $data['HIERARCHIE_ID']=$this->input->post('HIERARCHIE_ID');
      $data['sexe'] = $this->Model->getList("admin_sexe");
      $data['SEXE_ID']=$this->input->post('SEXE_ID');
      $this->load->view('Employes_Add_View',$data);

        }

     else
        {
   
        $data_collabo=array(
         'COLLABORATEUR_CNI'=>$this->input->post('COLLABORATEUR_CNI'),
         'COLLABORATEUR_NOM'=>$this->input->post('COLLABORATEUR_NOM'),
         'COLLABORATEUR_PRENOM'=>$this->input->post('COLLABORATEUR_PRENOM'),
         'COLLABORATEUR_TEL'=>$this->input->post('COLLABORATEUR_TEL'),
         'EMAIL'=>$this->input->post('EMAIL'),
         'SEXE_ID'=>$this->input->post('SEXE_ID'), 
         'ADRESSE_ACTUEL'=>$this->input->post('ADRESSE_ACTUEL'),
         'HIERARCHIE_ID'=>$this->input->post('HIERARCHIE_ID'),
         'DATE_NAISSANCE'=>$this->input->post('DATE_NAISSANCE'));

        $id_collabo=$this->Model->insert_last_id('admin_collaborateurs',$data_collabo);

        //s'il sera un utilisateur
        $PROFIL_ID=$this->input->post('PROFIL_ID');
        if (!empty($PROFIL_ID))
        {
          $data_user=array(
         'USERNAME'=>$this->input->post('EMAIL'),
         'TELEPHONE'=>$this->input->post('COLLABORATEUR_TEL'),
         'PASSWORD'=>md5($this->input->post('COLLABORATEUR_TEL')),
         'COLLABORATEUR_ID'=>$id_collabo,
         'NOM_PRENOM'=>$this->input->post('COLLABORATEUR_NOM').' '.$this->input->post('COLLABORATEUR_PRENOM'),
         'PROFIL_ID'=>$this->input->post('PROFIL_ID'));
         $this->Model->insert_last_id('admin_users',$data_user);
       
        // $EMAIL=$this->input->post('EMAIL');
        // $message='Cher(e) 'Mr/Mme' <b>'.$this->input->post('COLLABORATEUR_NOM').' '.$this->input->post('COLLABORATEUR_PRENOM').'</b>, <br><b>Vos identifiants de connexion sont username: '.$this->input->post('COLLABORATEUR_TEL'). '</b> <br> Password : '.$this->input->post('COLLABORATEUR_TEL'). '</b> <br><b> Vous cliquez <a href="'.base_url().'"> ici pour se connecter </a> sur la plateforme</b> <br> Cordialement Merci.';
        // $this->notifications->send_mail_badia(array("mail"=>"badia@socar.bi","name"=>"volcano"),$EMAIL,"notification",array(),$message,array());
        }

        $datas['message']='<div class="alert alert-success text-center" id="message">Enregistrement de '.$this->input->post('COLLABORATEUR_NOM').' '.$this->input->post('COLLABORATEUR_PRENOM').'</b> faite avec succès</div>';
         $this->session->set_flashdata($datas);
         redirect(base_url('administration/Employes/listing'));

        }



     }





    public function listing()
    {

      $resultat=$this->Model->getRequete('SELECT `COLLABORATEUR_CNI`,EMAIL,COLLABORATEUR_ID,`COLLABORATEUR_NOM`,`COLLABORATEUR_PRENOM`,`COLLABORATEUR_TEL`,`COLLABORATEUR_TEL2`,`ADRESSE_ACTUEL`,`DATE_NAISSANCE`,admin_hierarchie.HIERARCHIE_DESCR, admin_collaborateurs.STATUS FROM admin_collaborateurs LEFT JOIN admin_hierarchie ON admin_hierarchie.HIERARCHIE_ID=admin_collaborateurs.HIERARCHIE_ID ORDER BY COLLABORATEUR_NOM,COLLABORATEUR_PRENOM');
      $tabledata=array();
      
      foreach ($resultat as $key) 
         {


          if ($key['STATUS'] == 1) {
            $stat = 'Actif';
            $fx = 'desactiver';
            $col = 'btn-danger';
            $titr = 'Désactiver';
            $stitr = 'voulez-vous désactiver cet employé? ';
            $bigtitr = 'Désactivation de cet employé';
          }
          else{
            $stat = 'Innactif';
            $fx = 'reactiver';
            $col = 'btn-success';
            $titr = 'Réactiver';
            $stitr = 'voulez-vous réactiver cet employé? ';
            $bigtitr = 'Réactivation de cet employé';
          }

          if (!empty($key['COLLABORATEUR_TEL2'])) 
          {
          $tel2=' / '.$key['COLLABORATEUR_TEL2'];
          }
          else
          {
          $tel2=''; 
          }
          $colabo=array();
          $colabo[]=$key['COLLABORATEUR_NOM'].' '.$key['COLLABORATEUR_PRENOM']; 
          // $colabo[]=$key['COLLABORATEUR_CNI'];
          $colabo[]=$key['COLLABORATEUR_TEL'].''.$tel2;
          $colabo[]=$key['EMAIL']; 
          // $colabo[]=$key['DATE_NAISSANCE']; 
          // $colabo[]=$key['ADRESSE_ACTUEL'];
          $colabo[]=$key['HIERARCHIE_DESCR'];
          $colabo[]=$stat;
          if($this->mylibrary->get_permission('Prix_Carburant') ==1) { 
          
          $colabo['OPTIONS'] = '<div class="dropdown ">
                    <a class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">Actions
                    <span class="caret"></span></a>
                    <ul class="dropdown-menu dropdown-menu-right">
                    <li><a class="dropdown-item" href="'.base_url('administration/Employes/details/' . $key['COLLABORATEUR_ID']) .'"> D&eacute;tails et Historique </a> </li>
                    <li><a class="dropdown-item" href="'. base_url('administration/Employes/getOne/' . $key['COLLABORATEUR_ID']) .'"> Modifier </a> </li>
                    <li><a hre="#" data-toggle="modal" data-target="#mydelete'. $key['COLLABORATEUR_ID'] .'" class="dropdown-item" href="#" data-toggle="modal" data-target="#desactcat'.$key['COLLABORATEUR_ID'].'"> '.$titr.' </a> </li>
                    </ul>
                  </div>';

           // $colabo['OPTIONS'] .= "<li style='margin-left:30px'><a hre='#' data-toggle='modal' 
           //                        data-target='#mydelete" . $key['COLLABORATEUR_ID'] . "' ><font color='red'><i class='fa fa-trash' aria-hidden='true' ></i> Supprimer</font></a></li>";
  
          $colabo['OPTIONS'] .= "<div class='modal fade' id='mydelete" . $key['COLLABORATEUR_ID'] . "'>
                                        <div class='modal-dialog'>
                                            <div class='modal-content'>

                                                <div class='modal-body'>
                                                    <h5>".$stitr." <b>" .$key['COLLABORATEUR_NOM'].' '.$key['COLLABORATEUR_PRENOM'] ."</b>?</h5>
                                                </div>

                                               <div class='modal-footer'>
                                                    <a class='btn ".$col." btn-md' href='" . base_url('administration/Employes/'.$fx.'/'. $key['COLLABORATEUR_ID']) . "'>".$titr."</a>
                                                    <button class='btn btn-primary btn-md' class='close' data-dismiss='modal'>Quitter</button>
                                                </div>

                                            </div>
                                        </div>
                                    </div></form>";
              }
  else
  {
 $colabo['OPTIONS']='<font style="color:red"><center><i class="fa fa-times-circle"></i></center></font>';  
  }
                      

                          
       $tabledata[]=$colabo;
     
     }

        $template = array(
            'table_open' => '<table id="mytable" class="table table-bordered table-striped">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('Nom & Prénom','Téléphone','Email','Poste','Status','Options'));
        $data['title'] = " Employé";
        $data['stitle'] = " Employé";
        $data['employe']=$tabledata;
        $this->load->view('Employes_List_View',$data);

    }



    public function getOne($id)
          {
      
          $this->Is_permis();
          $data['employe']=$this->Model->getRequeteOne('SELECT `COLLABORATEUR_CNI`,EMAIL,admin_collaborateurs.COLLABORATEUR_ID,`COLLABORATEUR_NOM`,`COLLABORATEUR_PRENOM`,`COLLABORATEUR_TEL`,`COLLABORATEUR_TEL2`,`ADRESSE_ACTUEL`,`DATE_NAISSANCE`,admin_collaborateurs.SEXE_ID,admin_hierarchie.HIERARCHIE_DESCR,admin_hierarchie.`HIERARCHIE_ID`,admin_users.PROFIL_ID FROM admin_collaborateurs LEFT JOIN admin_hierarchie ON admin_hierarchie.HIERARCHIE_ID=admin_collaborateurs.HIERARCHIE_ID LEFT JOIN admin_users ON admin_users.COLLABORATEUR_ID=admin_collaborateurs.COLLABORATEUR_ID LEFT JOIN admin_profils ON admin_profils.PROFIL_ID=admin_users.PROFIL_ID LEFT JOIN admin_sexe ON admin_sexe.SEXE_ID=admin_collaborateurs.SEXE_ID WHERE admin_collaborateurs.COLLABORATEUR_ID='.$id.'');
            $data['COLLABORATEUR_ID']=$id;
            $data['profiles'] = $this->Model->getList("admin_profils");
            $data['hierarchie'] = $this->Model->getList("admin_hierarchie");
            $data['sexe'] = $this->Model->getList("admin_sexe");
            $data['title'] = " Employé";
            $data['stitle'] = " Employé";
            // print_r($data['employe']);
            // exit();
            $this->load->view('Employes_Update_View',$data);

          }
         

    public function update()
      {

      $this->form_validation->set_rules('COLLABORATEUR_NOM','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">Le nom du collaborateur  est obligatoire</font>'));

      $this->form_validation->set_rules('COLLABORATEUR_PRENOM','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">Le prénom est obligatoire</font>'));

      $this->form_validation->set_rules('COLLABORATEUR_CNI','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">Le CNI est obligatoire</font>'),array('is_unique'=>'<font style="color:red;size:2px;">Le CNI est unique</font>'));

      $this->form_validation->set_rules('COLLABORATEUR_TEL','', 'trim|required|callback_check_tel1',array('required'=>'<font style="color:red;size:2px;">Le téléphone est obligatoire</font>'),array('is_unique'=>'<font style="color:red;size:2px;">Le téléphone est unique</font>'));

      $EMAIL=$this->input->post('EMAIL');
      if (!empty($EMAIL))
      {
       $this->form_validation->set_rules('EMAIL','', 'trim|required|callback_check_mail',array('is_unique'=>'<font style="color:red;size:2px;">Le mail est unique</font>'));
      }

      $this->form_validation->set_rules('ADRESSE_ACTUEL','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">L\'adresse de résidence est obligatoire</font>'));

       $this->form_validation->set_rules('SEXE_ID', '', 'trim|required',array("required"=>"<font color='red'>Le genre est obligatoire</font>"));

      $this->form_validation->set_rules('HIERARCHIE_ID','', 'trim|required',array('required'=>'<font style="color:red;size:2px;">L\'hiérarchie est obligatoire</font>'));

      $this->form_validation->set_rules('DATE_NAISSANCE', '', 'trim|required',array("required"=>"<font color='red'>La date de naissance est obligatoire</font>"));


     if ($this->form_validation->run() == FALSE)
        { 
          
           $id=$this->input->post('COLLABORATEUR_ID');
           $data['employe']=$this->Model->getRequeteOne('SELECT `COLLABORATEUR_CNI`,EMAIL,admin_collaborateurs.COLLABORATEUR_ID,`COLLABORATEUR_NOM`,`COLLABORATEUR_PRENOM`,`COLLABORATEUR_TEL`,`COLLABORATEUR_TEL2`,`ADRESSE_ACTUEL`,`DATE_NAISSANCE`,admin_hierarchie.HIERARCHIE_DESCR,admin_hierarchie.`HIERARCHIE_ID`,admin_collaborateurs.SEXE_ID,admin_users.PROFIL_ID FROM admin_collaborateurs LEFT JOIN admin_hierarchie ON admin_hierarchie.HIERARCHIE_ID=admin_collaborateurs.HIERARCHIE_ID LEFT JOIN admin_users ON admin_users.COLLABORATEUR_ID=admin_collaborateurs.COLLABORATEUR_ID LEFT JOIN admin_profils ON admin_profils.PROFIL_ID=admin_users.PROFIL_ID LEFT JOIN admin_sexe ON admin_sexe.SEXE_ID=admin_collaborateurs.SEXE_ID WHERE admin_collaborateurs.COLLABORATEUR_ID='.$id.'');
            $data['COLLABORATEUR_ID']=$id;
            $data['profiles'] = $this->Model->getList("admin_profils");
            $data['hierarchie'] = $this->Model->getList("admin_hierarchie");
            $data['sexe'] = $this->Model->getList("admin_sexe");
            $data['title'] = " Employé";
            $data['stitle'] = " Employé";
            $this->load->view('Employes_Update_View',$data);
        }

     else
        {
   
        $data_collabo=array(
         'COLLABORATEUR_CNI'=>$this->input->post('COLLABORATEUR_CNI'),
         'COLLABORATEUR_NOM'=>$this->input->post('COLLABORATEUR_NOM'),
         'COLLABORATEUR_PRENOM'=>$this->input->post('COLLABORATEUR_PRENOM'),
         'COLLABORATEUR_TEL'=>$this->input->post('COLLABORATEUR_TEL'),
         'EMAIL'=>$this->input->post('EMAIL'), 
         'SEXE_ID'=>$this->input->post('SEXE_ID'), 
         'ADRESSE_ACTUEL'=>$this->input->post('ADRESSE_ACTUEL'),
         'HIERARCHIE_ID'=>$this->input->post('HIERARCHIE_ID'),
         'DATE_NAISSANCE'=>$this->input->post('DATE_NAISSANCE'));
        $id=$this->input->post('COLLABORATEUR_ID');
        $this->Model->update('admin_collaborateurs',array('COLLABORATEUR_ID'=>$id),$data_collabo);

        //s'il sera un utilisateur
        $PROFIL_ID=$this->input->post('PROFIL_ID');
        if (!empty($PROFIL_ID))
        {
          $data_user=array(
         'USERNAME'=>$this->input->post('EMAIL'),
         'TELEPHONE'=>$this->input->post('COLLABORATEUR_TEL'),
         'PASSWORD'=>md5($this->input->post('COLLABORATEUR_TEL')),
         'COLLABORATEUR_ID'=>$id,
         'NOM_PRENOM'=>$this->input->post('COLLABORATEUR_NOM').' '.$this->input->post('COLLABORATEUR_PRENOM'),
         'PROFIL_ID'=>$this->input->post('PROFIL_ID'));

          if($this->Model->checkvalue('admin_users',array('COLLABORATEUR_ID'=>$id)))
           {
           $this->Model->update('admin_users',array('COLLABORATEUR_ID'=>$id),$data_user);
           }
           else
           {
           $this->Model->insert_last_id('admin_users',$data_user); 
           }
         
       
        // $EMAIL=$this->input->post('EMAIL');
        // $message='Cher(e) 'Mr/Mme' <b>'.$this->input->post('COLLABORATEUR_NOM').' '.$this->input->post('COLLABORATEUR_PRENOM').'</b>, <br><b>Vos identifiants de connexion sont username: '.$this->input->post('COLLABORATEUR_TEL'). '</b> <br> Password : '.$this->input->post('COLLABORATEUR_TEL'). '</b> <br><b> Vous cliquez <a href="'.base_url().'"> ici pour se connecter </a> sur la plateforme</b> <br> Cordialement Merci.';
        // $this->notifications->send_mail_badia(array("mail"=>"badia@socar.bi","name"=>"volcano"),$EMAIL,"notification",array(),$message,array());
        }

        //si on ne veut pas qu'il va se connecte
        if($this->Model->checkvalue('admin_users',array('COLLABORATEUR_ID'=>$id)) && empty($PROFIL_ID))
        {
        $this->Model->delete('admin_users',array('COLLABORATEUR_ID'=>$id));
        }

        $datas['message']='<div class="alert alert-success text-center" id="message">Modification de '.$this->input->post('COLLABORATEUR_NOM').' '.$this->input->post('COLLABORATEUR_PRENOM').'</b> faite avec succès</div>';
         $this->session->set_flashdata($datas);
         redirect(base_url('administration/Employes/listing'));

        }
  
      }
    

      public function desactiver($id)
    {
      $this->Model->update('admin_collaborateurs',array('COLLABORATEUR_ID'=>$id),array('STATUS'=>0));
      $this->Model->update('admin_users',array('COLLABORATEUR_ID'=>$id),array('IS_ACTIVE'=>0));
      $message = "<div class='alert alert-success' id='message'>
                            Employés désactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('administration/Employes/listing'));

    }

  public function reactiver($id)
    {
      $this->Model->update('admin_collaborateurs',array('COLLABORATEUR_ID'=>$id),array('STATUS'=>1));
      $this->Model->update('admin_users',array('COLLABORATEUR_ID'=>$id),array('IS_ACTIVE'=>1));
      $message = "<div class='alert alert-success' id='message'>
                            Employés réactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('administration/Employes/listing'));
    }

    public function details($id)
    {
      # code...
      // echo "string";
      $data['details'] = $this->Model->getRequeteOne('SELECT * FROM `admin_collaborateurs` JOIN admin_hierarchie ON admin_collaborateurs.HIERARCHIE_ID = admin_collaborateurs.HIERARCHIE_ID JOIN admin_sexe ON admin_sexe.SEXE_ID = admin_collaborateurs.SEXE_ID WHERE admin_collaborateurs.COLLABORATEUR_ID = '.$id.' ');

      $data['commandecommande'] = $this->Model->getRequete('SELECT restau_commande.DATE_TIME_COMMANDE, masque_table_restaurant.NUM_TABLE, restau_status_commande.DESCRIPTION AS DESCRIPTIONC, restau_status_paiement.DESCRIPTION AS PDESCRIPTION, restau_commande.MONTANTTOTAL, restau_commande.MONTANT_RESTANT FROM `restau_commande` JOIN masque_table_restaurant ON masque_table_restaurant.TABLE_ID = restau_commande.ID_TABLE JOIN restau_status_commande ON restau_status_commande.STATU_COMMANDE_ID = restau_commande.STATU_COMMANDE_ID JOIN restau_status_paiement ON restau_status_paiement.ID_STATUS_PAYEMENT = restau_commande.ID_STATUS_PAYEMENT WHERE restau_commande.COLLABORATEUR_ID_COMMANDE = '.$id.' ');
      $data['scommandecommande'] = $this->Model->getRequeteOne('SELECT COUNT(restau_commande.ID_COMMANDE) AS NB, SUM(restau_commande.MONTANTTOTAL) AS MONTANTTOTAL, SUM(restau_commande.MONTANT_RESTANT) AS MONTANT_RESTANT FROM `restau_commande` WHERE restau_commande.COLLABORATEUR_ID_COMMANDE = '.$id.' ');


      $data['commandelivre'] = $this->Model->getRequete('SELECT restau_commande.DATE_TIME_COMMANDE, masque_table_restaurant.NUM_TABLE, restau_status_commande.DESCRIPTION AS DESCRIPTIONC, restau_status_paiement.DESCRIPTION AS PDESCRIPTION, restau_commande.MONTANTTOTAL, restau_commande.MONTANT_RESTANT FROM `restau_commande` JOIN masque_table_restaurant ON masque_table_restaurant.TABLE_ID = restau_commande.ID_TABLE JOIN restau_status_commande ON restau_status_commande.STATU_COMMANDE_ID = restau_commande.STATU_COMMANDE_ID JOIN restau_status_paiement ON restau_status_paiement.ID_STATUS_PAYEMENT = restau_commande.ID_STATUS_PAYEMENT WHERE restau_commande.COLLABORATEUR_ID_LIVRAISON = '.$id.' ');
      $data['scommandelivre'] = $this->Model->getRequeteOne('SELECT COUNT(restau_commande.ID_COMMANDE) AS NB, SUM(restau_commande.MONTANTTOTAL) AS MONTANTTOTAL, SUM(restau_commande.MONTANT_RESTANT) AS MONTANT_RESTANT FROM `restau_commande` WHERE restau_commande.COLLABORATEUR_ID_LIVRAISON = '.$id.' ');


      $data['commandeannule'] = $this->Model->getRequete('SELECT restau_commande.DATE_TIME_COMMANDE, masque_table_restaurant.NUM_TABLE, restau_status_commande.DESCRIPTION AS DESCRIPTIONC, restau_status_paiement.DESCRIPTION AS PDESCRIPTION, restau_commande.MONTANTTOTAL, restau_commande.MONTANT_RESTANT FROM `restau_commande` JOIN masque_table_restaurant ON masque_table_restaurant.TABLE_ID = restau_commande.ID_TABLE JOIN restau_status_commande ON restau_status_commande.STATU_COMMANDE_ID = restau_commande.STATU_COMMANDE_ID JOIN restau_status_paiement ON restau_status_paiement.ID_STATUS_PAYEMENT = restau_commande.ID_STATUS_PAYEMENT WHERE restau_commande.COLLABORATEUR_ID_ANNULE = '.$id.' ');
      $data['scommandeannule'] = $this->Model->getRequeteOne('SELECT COUNT(restau_commande.ID_COMMANDE) AS NB, SUM(restau_commande.MONTANTTOTAL) AS MONTANTTOTAL, SUM(restau_commande.MONTANT_RESTANT) AS MONTANT_RESTANT FROM `restau_commande` WHERE restau_commande.COLLABORATEUR_ID_ANNULE = '.$id.' ');

      $data['title']=' Employé ';
      $data['stitle']=' Employé ';
      $this->load->view('Employes_Details_View',$data);
    }

}
