<!DOCTYPE html>
<html lang="en">

<head>
  <?php include 'includes/header_site.php' ?>
</head>

<body>

  <!-- ======= Header ======= -->
  <header id="header" class="fixed-top">
    <?php include 'includes/menu_site.php'?>
  </header><!-- End Header -->

  <!-- ======= main ======= -->
   <main id="main">

    <!-- ======= Breadcrumbs ======= -->
    <section id="breadcrumbs" class="breadcrumbs">
      <div class="container">

        <div class="d-flex justify-content-between align-items-center">
          <h2>Contact</h2>
          <ol>
            <li><a href="<?=base_url()?>">Acceuil</a></li>
            <li>Contact</li>
          </ol>
        </div>

      </div>
    </section><!-- End Breadcrumbs -->

    <section id="contact" class="contact">
      <div class="container">

        <div class="row justify-content-center" data-aos="fade-up">

          <div class="col-lg-10">

            <div class="info-wrap">
              <div class="row">
                <div class="col-lg-5 info">
                  <i class="icofont-google-map"></i>
                  <h4>Localisation:</h4>
                  <?php $localisation = $this->config->item('contact_localisation');?>
                  <p>
                  	<?php 
                  	if(!empty($localisation)){
                  	  foreach ($localisation as $key => $value) {
                  	    echo $value.'<br>'; 
                  	  }
                  	}
                  	?>
                  </p>
                </div>

                <div class="col-lg-4 info mt-4 mt-lg-0">
                  <i class="icofont-envelope"></i>
                  <h4>Email:</h4>
                  <?php $emails = $this->config->item('contact_email');?>
                  <p>
                  	<?php 
                  	if(!empty($emails)){
                  	  foreach ($emails as $key => $value) {
                  	    echo $value.'<br>'; 
                  	  }
                  	}
                  	?>
                  </p>
                </div>

                <div class="col-lg-3 info mt-3 mt-lg-0">
                  <i class="icofont-phone"></i>
                  <h4>Appel:</h4>
                  <?php $tels = $this->config->item('contact_tels')?>
                  <p>
                  	<?php 
                  	if(!empty($tels)){
                  	  foreach ($tels as $key => $value) {
                  	    echo $value.'<br>'; 
                  	  }
                  	}
                  	?>
                  </p>
                </div>
              </div>
            </div>

          </div>

        </div>

        <div class="row mt-5 justify-content-center" data-aos="fade-up">
          <div class="col-lg-10">
            <form action="<?=base_url('hotel/Contact_Front/save_message')?>" method="post" role="form" class="php-email-form">
              <div class="form-row">
                <div class="col-md-6 form-group">
                  <input type="text" name="name" class="form-control" id="name" placeholder="Votre Nom & Prénom" data-rule="minlen:4" data-msg="Le champ Nom & Prénom est réquis" />
                  <div class="validate"></div>
                </div>
                <div class="col-md-6 form-group">
                  <input type="email" class="form-control" name="email" id="email" placeholder="Votre Email" data-rule="email" data-msg="Un email valid est réquis" />
                  <div class="validate"></div>
                </div>
              </div>
              <div class="form-group">
                <input type="text" class="form-control" name="subject" id="subject" placeholder="Object" data-rule="minlen:4" data-msg="Le sujet de votre conversation doit avoir au moins 8 caractères" />
                <div class="validate"></div>
              </div>
              <div class="form-group">
                <textarea class="form-control" name="message" rows="5" data-rule="required" data-msg="SVP mettez un message !" placeholder="Message"></textarea>
                <div class="validate"></div>
              </div>
              <div class="mb-3">
                <div class="loading">Chargement</div>
                <div class="error-message"></div>
                <div class="sent-message">Votre message a été envoie. Merci!</div>
              </div>
              <div class="text-center"><button type="submit">Envoyer le message</button></div>
            </form>
          </div>

        </div>

      </div>
    </section><!-- End Contact Section -->

    <!-- ======= Contact Section ======= -->
    <div class="map-section">
      <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3982.84577537021!2d29.349251614113644!3d-3.3878174424825533!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x19c18315845f550d%3A0x27e74fbc2bc33ad8!2sPearl%20Residence!5e0!3m2!1sfr!2sbi!4v1596184434429!5m2!1sfr!2sbi" width="100%" height="450px" frameborder="0" style="border:0;" allowfullscreen="" aria-hidden="false" tabindex="0"></iframe>
    </div>
  </main>
  <!-- ======= Footer ======= -->
  <footer id="footer">
    <?php include'includes/footer_site.php'?>
  </footer><!-- End Footer -->
  <?php include'includes/js_footer_site.php'?>
 </body>
</html>