<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Stock extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->Is_Connected();
    }

    public function Is_Connected()
       {

       if (empty($this->session->userdata('PEA_USER_ID')))
        {
         redirect(base_url('Login/'));
        }
       }



    public function index()
    {
      $data['title']=' Stock';
      $data['stitle']=' Stock';
      $this->load->view('Stock_Add_View',$data);
    }


    public function add()
  {

  $DESCRIPTION=$this->input->post('DESCRIPTION');
  $EXPLICATION=$this->input->post('EXPLICATION');
  $IS_STOCK_VENTE = $this->input->post('IS_STOCK_VENTE');
  $this->form_validation->set_rules('DESCRIPTION', 'Nom du stock', 'required');

   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'>
                            Stock non enregistr&eacute;
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['DESCRIPTION']=$this->input->post('DESCRIPTION');
    $data['EXPLICATION']=$this->input->post('EXPLICATION');
    $data['IS_STOCK_VENTE']=$this->input->post('IS_STOCK_VENTE');
    $data['title']=' Stock';
    $data['stitle']=' Stock';
    $this->load->view("Stock_Add_View",$data);
   }
   else{
    $datas=array('DESCRIPTION'=>$DESCRIPTION,
                 'EXPLICATION'=>$EXPLICATION,
                 'IS_STOCK_VENTE'=>$IS_STOCK_VENTE
                );
    $this->Model->insert_last_id('masque_stock',$datas);
    $message = "<div class='alert alert-success' id='message'>
                            Stock enregistr&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Stock/listing'));    

   }
   

  }

     public function listing()
    {

      $resultat=$this->Model->getRequete('SELECT * from masque_stock');
      $tabledata=array();
      
      foreach ($resultat as $key) 
         {
          if ($key['STATUS'] == 1) {
            $stat = 'Actif';
            $fx = 'desactiver';
            $col = 'btn-danger';
            $titr = 'Désactiver';
            $stitr = 'voulez-vous désactiver ce stock ';
            $bigtitr = 'Désactivation du stock';
          }
          else{
            $stat = 'Innactif';
            $fx = 'reactiver';
            $col = 'btn-success';
            $titr = 'Réactiver';
            $stitr = 'voulez-vous réactiver ce stock ';
            $bigtitr = 'Réactivation du stock';
          }

          if ($key['IS_STOCK_VENTE'] == 1) {
            $ventes = ' (Stock de vente)';
          }
          else{
            $ventes = '';
          }

          $chambr=array();
          $chambr[]=$key['DESCRIPTION'].''.$ventes;
          $chambr[]=$key['EXPLICATION'];  
          $chambr[]=$stat;
          $chambr[] = '<div class="modal fade" id="deleteStock'.$key['STOCK_ID'].'" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">'.$bigtitr.'</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h6><b>Mr/Mme , </b> '.$stitr.' ('.$key['DESCRIPTION'].')?</h6>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
        <a href="'.base_url('saisie/Stock/'.$fx.'/'.$key['STOCK_ID']).'" class="btn '.$col.'">'.$titr.'</a>
      </div>
    </div>
  </div>
</div>

          <div class="dropdown ">
                    <a class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">Actions
                    <span class="caret"></span></a>
                    <ul class="dropdown-menu dropdown-menu-right">
                    <li><a class="dropdown-item" href="'.base_url('saisie/Stock/details/'.$key['STOCK_ID']).'"> Details et Historique </a> </li>
                    <li><a class="dropdown-item" href="'.base_url('saisie/Stock/index_update/'.$key['STOCK_ID']).'"> Modifier </a> </li>
                    <li><a class="dropdown-item" href="#" data-toggle="modal" data-target="#deleteStock'.$key['STOCK_ID'].'"> '.$titr.' </a> </li>
                    </ul>
                  </div>';                          
       $tabledata[]=$chambr;
     
     }

        $template = array(
            'table_open' => '<table id="mytable" class="table table-bordered table-striped">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('Nom','Description','Status','Option'));
        $data['title'] = " Stock";
        $data['stitle']=' Stock';
        $data['chamb']=$tabledata;
        $this->load->view('Stock_List_View',$data);

    }


    public function index_update($id)
    {
      $data['title']=' Stock';
      $data['stitle']=' Stock';
      $data['selected']=$this->Model->getOne('masque_stock',array('STOCK_ID'=>$id));
      $this->load->view('Stock_Update_View',$data);
    }


      public function update()
  {

  $DESCRIPTION=$this->input->post('DESCRIPTION');
  $EXPLICATION=$this->input->post('EXPLICATION');
  $IS_STOCK_VENTE = $this->input->post('IS_STOCK_VENTE');
  $STOCK_ID = $this->input->post('STOCK_ID');
  $this->form_validation->set_rules('DESCRIPTION', 'Nom du stock', 'required');

   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'>
                            Mise à jour du stock non enregistr&eacute;
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['title']=' Stock';
    $data['stitle']=' Stock';
    $data['selected']=$this->Model->getOne('masque_stock',array('STOCK_ID'=>$STOCK_ID));
    $this->load->view("Stock_Update_View",$data);
   }
   else{
    $datas=array('DESCRIPTION'=>$DESCRIPTION,
                 'EXPLICATION'=>$EXPLICATION,
                 'IS_STOCK_VENTE'=>$IS_STOCK_VENTE
                );
    $this->Model->update('masque_stock',array('STOCK_ID'=>$STOCK_ID),$datas);
    $message = "<div class='alert alert-success' id='message'>
                            Stock mis à jour enregistr&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Stock/listing'));    

   }
  }

public function desactiver($id)
    {
      $this->Model->update('masque_stock',array('STOCK_ID'=>$id),array('STATUS'=>0));
      $message = "<div class='alert alert-success' id='message'>
                            Stock désactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Stock/listing')); 
    }

  public function reactiver($id)
    {
      $this->Model->update('masque_stock',array('STOCK_ID'=>$id),array('STATUS'=>1));
      $message = "<div class='alert alert-success' id='message'>
                            Stock Réactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Stock/listing')); 
    }

    public function details()
    {
      $data['title']=' Stock';
      $data['stitle']=' Stock';
      $this->load->view('Stock_Details_View',$data);
    }

}
?>