<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Tables extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->Is_Connected();
    }

    public function Is_Connected()
       {

       if (empty($this->session->userdata('PEA_USER_ID')))
        {
         redirect(base_url('Login/'));
        }
       }



    public function index()
    {
      $data['title']='Tables';
      $data['stitle']='Tables';
      $this->load->view('Tables_Add_View',$data);
    }


    public function add()
  {

  $NUM_TABLE=$this->input->post('NUM_TABLE');
  $DESCRIPTION_EMPLACEMENT=$this->input->post('DESCRIPTION_EMPLACEMENT');
 

   $this->form_validation->set_rules('NUM_TABLE','Numero de la table', 'required|is_unique[masque_table_restaurant.NUM_TABLE]');
   $this->form_validation->set_rules('DESCRIPTION_EMPLACEMENT', 'Description emplacement',  'required');

   // $this->form_validation->set_rules('email', 'Email', 'required|valid_email');

   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'>
                            Table non enregistr&eacute;
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
    // $data=array();
    $data['title']='Tables';
    $data['stitle']='Tables';
    $this->load->view("Tables_Add_View",$data);
   }
   else{

    $datas=array('NUM_TABLE'=>$NUM_TABLE,
                 'DESCRIPTION_EMPLACEMENT'=>$DESCRIPTION_EMPLACEMENT,
                );
   
    $this->Model->insert_last_id('masque_table_restaurant',$datas);

    $message = "<div class='alert alert-success' id='message'>
                            Table enregistr&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Tables/listing'));    

   }

  }

     public function listing()
    {

      $resultat=$this->Model->getRequete('SELECT * FROM masque_table_restaurant');
      $tabledata=array();
      
      foreach ($resultat as $key) 
         {
          $nboc=$this->Model->getRequeteOne('SELECT count(ID_TABLE) NB_TABLE_ID FROM restau_commande where ID_TABLE='.$key['TABLE_ID'].'');

          if ($key['STATUS'] == 1) {
            $stat = 'Actif';
            $fx = 'desactiver';
            $col = 'btn-danger';
            $titr = 'Désactiver';
            $stitr = 'voulez-vous désactiver la table ';
            $bigtitr = 'Désactivation de la table';
          }
          else{
            $stat = 'Innactif';
            $fx = 'reactiver';
            $col = 'btn-success';
            $titr = 'Réactiver';
            $stitr = 'voulez-vous réactiver la table ';
            $bigtitr = 'Réactivation de la table';
          }

          $chambr=array();
          $chambr[]=$key['NUM_TABLE'];
          $chambr[]=$key['DESCRIPTION_EMPLACEMENT'];  
          $chambr[]=$nboc['NB_TABLE_ID'];
          $chambr[]=$stat;
          $chambr[]='<div class="modal fade" id="desactcat'.$key['TABLE_ID'].'" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">'.$bigtitr.'</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h6><b>Mr/Mme , </b> '.$stitr.' ('.$key['NUM_TABLE'].')?</h6>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
        <a href="'.base_url('saisie/Tables/'.$fx.'/'.$key['TABLE_ID']).'" class="btn '.$col.'">'.$titr.'</a>
      </div>
    </div>
  </div>
</div>

          <div class="dropdown ">
                    <a class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">Actions
                    <span class="caret"></span></a>
                    <ul class="dropdown-menu dropdown-menu-right">
                    <li><a class="dropdown-item" href="'.base_url('saisie/Tables/details/'.$key['TABLE_ID']).'"> Details et Historique </a> </li>
                    <li><a class="dropdown-item" href="'.base_url('saisie/Tables/index_update/'.$key['TABLE_ID']).'"> Modifier </a> </li>
                    <li><a class="dropdown-item" href="#" data-toggle="modal" data-target="#desactcat'.$key['TABLE_ID'].'"> '.$titr.' </a> </li>
                    </ul>
                  </div>';
       $tabledata[]=$chambr;
     
     }

        $template = array(
            'table_open' => '<table id="mytable" class="table table-bordered table-striped">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('Num','Emplacement','Nb occupation','Status','Option'));
        $data['title'] = " Table";
        $data['stitle']='Tables';
        $data['chamb']=$tabledata;
        $this->load->view('Tables_List_View',$data);

    }

public function index_update($id)
    {
      $data['title']='Tables';
      $data['stitle']='Tables';
      $data['selected']=$this->Model->getOne('masque_table_restaurant',array('TABLE_ID'=>$id));
      $this->load->view('Tables_Update_View',$data);
    }


    public function update()
  {

  $NUM_TABLE=$this->input->post('NUM_TABLE');
  $DESCRIPTION_EMPLACEMENT=$this->input->post('DESCRIPTION_EMPLACEMENT');
  $TABLE_ID=$this->input->post('TABLE_ID');
 

   $this->form_validation->set_rules('NUM_TABLE','Numero de la table', 'required');
   $this->form_validation->set_rules('DESCRIPTION_EMPLACEMENT', 'Description emplacement',  'required');

   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'>
                            Table non mis &agrave; jour
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
    // $data=array();
    $data['title']='Tables';
      $data['stitle']='Tables';
      $data['selected']=$this->Model->getOne('masque_table_restaurant',array('TABLE_ID'=>$TABLE_ID));
      $this->load->view('Tables_Update_View',$data);
   }
   else{

    $datas=array('NUM_TABLE'=>$NUM_TABLE,
                 'DESCRIPTION_EMPLACEMENT'=>$DESCRIPTION_EMPLACEMENT,
                );
   
    $this->Model->update('masque_table_restaurant',array('TABLE_ID'=>$TABLE_ID),$datas);

    $message = "<div class='alert alert-success' id='message'>
                            Table mis &agrave; jour avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Tables/listing'));    

   }

  }



  public function desactiver($id)
    {
      $this->Model->update('masque_table_restaurant',array('TABLE_ID'=>$id),array('STATUS'=>0));
      $message = "<div class='alert alert-success' id='message'>
                            Table désactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Tables/listing')); 
    }

  public function reactiver($id)
    {
      $this->Model->update('masque_table_restaurant',array('TABLE_ID'=>$id),array('STATUS'=>1));
      $message = "<div class='alert alert-success' id='message'>
                            Table Réactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Tables/listing')); 
    }

    public function details()
    {
      $data['title']=' Table';
      $data['stitle']=' Table';
      $this->load->view('Tables_Details_View',$data);
    }

}
?>